//
//  File.swift
//  EcoWarriors
//
//  Created by Ria on 14/08/19.
//  Copyright © 2019 Ria. All rights reserved.
//

import UIKit
enum MenuOption: Int, CustomStringConvertible {
    
    case AboutUs
    case UE
    case CP
    case RP
    case RS
    case JOT
    case ContactUs
    
    var description: String {
        switch self {
        case .AboutUs: return "About us"
        case .UE: return "Upcoming events"
        case .CP: return "Completed projects"
        case .RP: return "Products"
        case .RS: return "Services"
        case .JOT: return "Join our team"
        case .ContactUs: return "Contact us"
        }
    }
    
    var image: UIImage {
        switch self {
        case .AboutUs: return UIImage(named: "AU") ?? UIImage()
        case .UE: return UIImage(named: "UE") ?? UIImage()
        case .CP: return UIImage(named: "CP") ?? UIImage()
        case .RP: return UIImage(named: "RPS") ?? UIImage()
        case .RS: return UIImage(named: "RP") ?? UIImage()
        case .JOT: return UIImage(named: "JOT") ?? UIImage()
        case .ContactUs: return UIImage(named: "CU") ?? UIImage()
        }
    }
    
}
